
#ifndef _MANAGER_H_
#define _MANAGER_H_

#include "main.h"
#include <vector>

class CMode;
class CCamera;
class CLight;
class CRenderer;		// _[
class CInputKeyboard;
class CInputMouse;
class CInputJoyStick;
class CTexManager;
class CModelManager;
class CFontManager;
class CScene;
class CEffect3DPoly;
class CWwise;
class CManager
{
public:
	CManager() {}
	~CManager() {}

	HRESULT Init(HINSTANCE hInstance, HWND hWnd, bool bWindow);
	void Uninit();
	void Update(HWND hWnd);
	void Draw();

	static const CRenderer &GetRenderer(void) { return *m_pRenderer; }					// _[̎擾
	static const CInputKeyboard &GetKeyboard(void) { return *m_pKeyboard; }
	static const CInputJoyStick &GetJoyStick(void) { return *m_pJoyStick; }
	static const CInputMouse &GetMouse(void) { return *m_pMouse; }
	static CModelManager *GetModelManager(void) { return m_pModelManager; }				// f}l[W̎擾
	static CTexManager *GetTexManager(void) { return m_pTexManager; }					// eNX`}l[W̎擾
	static CFontManager *GetFontManager(void) { return m_pFontManager; }
	static CCamera *GetCamera(void) { return m_pCamera; }	// J
	static CLight *GetLight(void) { return m_pLight; }		// Cg
	static CWwise *GetWwise(void) { return m_pWwise; }		// Wwise

	static void SetMode(CMode *mode);

private:
	static CRenderer *m_pRenderer;					// _[̃|C^
	static CInputKeyboard* m_pKeyboard;
	static CInputJoyStick* m_pJoyStick;
	static CInputMouse* m_pMouse;
	static CModelManager *m_pModelManager;			// f}l[W
	static CTexManager *m_pTexManager;				// eNX`}l[W
	static CFontManager *m_pFontManager;
	static CCamera *m_pCamera;		// J
	static CLight *m_pLight;		// Cg
	static CWwise *m_pWwise;

	static CMode *m_mode;
};

#endif